/*
	AnimateһRleBitmap,ЩRleBitmapڴ
*/

#include "gl.h"
//#include "gengine.h"

#define ANI_SIGNATURE	0x00494e41	//"ANI"
/*
class Animate{
public:
	RleBitmap** pic;
	int totalFrames, currentFrame;
	int x, y;		//
	DWORD size;		//ݳ
	void* data;		//

	Animate();
	~Animate();

	int Draw( Bitmap* dest, int x, int y );
	void Restart( void );
	void SetXY( int x, int y );
};

int SaveAnimate( char* filename );
Animate* LoadAnimate( char* filename );
*/
Animate::Animate()
{
	pic = NULL;
	data = NULL;
	totalFrames = 0;
	currentFrame = 0;
	dir = 0;
	autoReverse = 0;
}

Animate::~Animate()
{
	int i;

	for( i=0; i<totalFrames; i++ ){
		if( pic[i] ){
			pic[i]->line = NULL;
			delete pic[i];
		}
	}
	delete pic;
	delete data;
}

//ֵΪʾһѭ
int Animate::Draw( Bitmap* dest, int x, int y )
{
	RleBitmapBlit( dest, x - Animate::x, y - Animate::y, pic[currentFrame] );
	currentFrame ++;
	if( currentFrame == totalFrames )
		currentFrame = 0;
	return currentFrame;
}

int Animate::DrawCurrentFrame( Bitmap* dest, int x, int y )
{
	RleBitmapBlit( dest, x - Animate::x, y - Animate::y, pic[currentFrame] );
	return currentFrame;
}

int Animate::GetNextFrame( RleBitmap** rbm ){
	if( dir == 0 ){
		*rbm = pic[currentFrame++];
		if( currentFrame == totalFrames ){
			if( autoReverse ){
				dir = 1;
				currentFrame = totalFrames - 1;
			}
			else
				currentFrame = 0;
		}
	}
	else{
		*rbm = pic[currentFrame--];
		if( currentFrame == -1 ){
			if( autoReverse ){
				dir = 0;
				currentFrame = 0;
			}
			else
				currentFrame = totalFrames - 1;
		}
	}
	return currentFrame;
};

void Animate::Restart( void )
{
	currentFrame = 0;
}

void Animate::SetXY( int x, int y )
{
	Animate::x = x;
	Animate::y = y;
}

/////////////////////////////////////////////////////////////////////
Animate* LoadAnimate( char* filename )
{
	File *fp;
	fp = cfile.Open( filename );
	if( fp == NULL )
		return NULL;

	int i, j, temp;

	fp->Read( &temp, 4 );
	if( temp != ANI_SIGNATURE ){
		fp->Close();
		return NULL;
	}

	Animate* ani = new Animate;
	if( ani == NULL ){
		fp->Close();
		return NULL;
	}
	//ʼ
	fp->Read( &(ani->totalFrames), sizeof(int) );
	fp->Read( &(ani->size), sizeof(int) );
	fp->Read( &(ani->x), sizeof(int) );
	fp->Read( &(ani->y), sizeof(int) );
	ani->pic = (RleBitmap**)new char[sizeof(RleBitmap*) * ani->totalFrames ];
	ZeroMemory( ani->pic, sizeof(RleBitmap*) * ani->totalFrames );
	ani->data = new char[ ani->size ];
	if( ani->pic == NULL || ani->data == NULL ){
		ani->totalFrames = 0;
		goto error;
	}
	//rleBitmap
	for( i=0; i<ani->totalFrames; i++ ){
		if( (ani->pic[i] = new RleBitmap) == NULL )
			goto error;
	}
		
	//rleBitmapͷ
	ani->pic[0]->line = (char**)ani->data;
	for( i=0, temp=0; i<ani->totalFrames; i++ ){
		fp->Read( &(ani->pic[i]->size), sizeof(DWORD));
		fp->Read( &(ani->pic[i]->colorDepth), sizeof(int) );
		fp->Read( &(ani->pic[i]->x), sizeof(int));
		fp->Read( &(ani->pic[i]->y), sizeof(int));
		fp->Read( &(ani->pic[i]->width), sizeof(int));
		fp->Read( &(ani->pic[i]->height), sizeof(int));
		ani->pic[i]->line = (char**)((DWORD)ani->pic[0]->line + temp);
		ani->pic[i]->line[0] = (char*)ani->pic[i]->line + ani->pic[i]->height * sizeof( char* );
		temp += ani->pic[i]->height * sizeof( char* ) + ani->pic[i]->size;
	}
	//
	for( i=0; i<ani->totalFrames; i++ ){
		for( j=0; j<ani->pic[i]->height; j++ )
			ani->pic[i]->line[j] = ani->pic[i]->line[0] + fp->Getdw();
		fp->Read( ani->pic[i]->line[0], ani->pic[i]->size );
	}
	//ʽת
	for( i=0; i<ani->totalFrames; i++ )
		ani->pic[i]->ConvertFormat( screenInfo.colorDepth );

	fp->Close();
	return ani;

error:
	fp->Close();
	delete ani;
	return NULL;
}

int SaveAnimate( char* filename, Animate* ani )
{
	return MakeAnimateFile( filename, ani->pic, ani->totalFrames );
}

int MakeAnimateFile( char* filename, RleBitmap** src, int num )
{
	if( src == NULL )
		return -1;

	FILE *fp = fopen( filename, "wb" );
	if( fp == NULL )
		return -1;

	int i, j, temp;
	Animate *ani = new Animate;
	if( ani == NULL ){
		fclose( fp );
		return -1;
	}

	ani->totalFrames = num;
	ani->size = 0;
	for( i=0; i<num; i++ )
		ani->size += src[i]->height * sizeof(char*) + src[i]->size;

	i = ANI_SIGNATURE;
	fwrite( &i, 4, 1, fp );
	fwrite( &(ani->totalFrames), sizeof(int), 1, fp );
	fwrite( &(ani->size), sizeof(DWORD), 1, fp );
	fwrite( &(ani->x), sizeof(int), 1, fp );
	fwrite( &(ani->y), sizeof(int), 1, fp );

	for( i=0; i<num; i++ ){
		//дrleBitmapͷ
		fwrite( &(src[i]->size), sizeof(src[i]->size), 1, fp );
		fwrite( &(src[i]->colorDepth), sizeof(src[i]->colorDepth), 1, fp );
		fwrite( &(src[i]->x), sizeof(src[i]->x), 1, fp );
		fwrite( &(src[i]->y), sizeof(src[i]->y), 1, fp );
		fwrite( &(src[i]->width), sizeof(src[i]->width), 1, fp );
		fwrite( &(src[i]->height), sizeof(src[i]->height), 1, fp );
	}
	for( i=0; i<num; i++ ){
		//дÿص׵ַline[0]ƫ
		for( j=0; j<src[i]->height; j++ ){
			temp = src[i]->line[j] - src[i]->line[0];
			fwrite( &temp, sizeof( DWORD ), 1, fp );
		}
		//д
		fwrite( src[i]->line[0], 1, src[i]->size, fp ); 
	}
	ani->totalFrames = 0;
	delete ani;
	fclose( fp );
	return 0;
}

static Animate *test[32];

int InitAni( void )
{
	int i;
	test[0] = LoadAnimate( "data\\picture\\warrior\\fight0.ani" );
	test[1] = LoadAnimate( "data\\picture\\warrior\\fight1.ani" );
	test[2] = LoadAnimate( "data\\picture\\warrior\\fight2.ani" );
	test[3] = LoadAnimate( "data\\picture\\warrior\\fight3.ani" );
	test[4] = LoadAnimate( "data\\picture\\warrior\\fight4.ani" );
	test[5] = LoadAnimate( "data\\picture\\warrior\\fight5.ani" );
	test[6] = LoadAnimate( "data\\picture\\warrior\\fight6.ani" );
	test[7] = LoadAnimate( "data\\picture\\warrior\\fight7.ani" );
	test[8] = LoadAnimate( "data\\picture\\warrior\\walk0.ani" );
	test[9] = LoadAnimate( "data\\picture\\warrior\\walk1.ani" );
	test[10] = LoadAnimate( "data\\picture\\warrior\\walk2.ani" );
	test[11] = LoadAnimate( "data\\picture\\warrior\\walk3.ani" );
	test[12] = LoadAnimate( "data\\picture\\warrior\\walk4.ani" );
	test[13] = LoadAnimate( "data\\picture\\warrior\\walk5.ani" );
	test[14] = LoadAnimate( "data\\picture\\warrior\\walk6.ani" );
	test[15] = LoadAnimate( "data\\picture\\warrior\\walk7.ani" );
	test[16] = LoadAnimate( "data\\picture\\warrior\\stand0.ani" );
	test[17] = LoadAnimate( "data\\picture\\warrior\\stand1.ani" );
	test[18] = LoadAnimate( "data\\picture\\warrior\\stand2.ani" );
	test[19] = LoadAnimate( "data\\picture\\warrior\\stand3.ani" );
	test[20] = LoadAnimate( "data\\picture\\warrior\\stand4.ani" );
	test[21] = LoadAnimate( "data\\picture\\warrior\\stand5.ani" );
	test[22] = LoadAnimate( "data\\picture\\warrior\\stand6.ani" );
	test[23] = LoadAnimate( "data\\picture\\warrior\\stand7.ani" );
	test[24] = LoadAnimate( "data\\picture\\warrior\\gothit0.ani" );
	test[25] = LoadAnimate( "data\\picture\\warrior\\gothit1.ani" );
	test[26] = LoadAnimate( "data\\picture\\warrior\\gothit2.ani" );
	test[27] = LoadAnimate( "data\\picture\\warrior\\gothit3.ani" );
	test[28] = LoadAnimate( "data\\picture\\warrior\\gothit4.ani" );
	test[29] = LoadAnimate( "data\\picture\\warrior\\gothit5.ani" );
	test[30] = LoadAnimate( "data\\picture\\warrior\\gothit6.ani" );
	test[31] = LoadAnimate( "data\\picture\\warrior\\gothit7.ani" );
	for( i=0; i<32; i++ ){
		if( test[i] == NULL )
			return -1;
		test[i]->SetXY ( 0, 30 );
	}
	return 0;
}

void testAni( void )
{
	int i, j;
	for( i=0; i<8; i++ )
		for( j=0; j<4; j++ );
		//	test[i*4+j]->Draw( backScreen, i*80, j*88 );
}
